#!/usr/bin/perl
###dgx.pl
##### Usage info/check and assignment of command line arguments

$] >= 5.004 or die "Perl version must be >= 5.004 (Currently $]).\n";

sub Usage {
  print STDERR <<END;

Usage: dgxit.pl imagefile 

Function:  runs dgx based on imagefile.rsc

Recognizes: *.slc
            *.int
            *.cor
            *.unw
            *.amp
            *.hgt
            *.hgt_holes
            *.dem
            *.dte
            *.dtm
            *.rect
            *.msk
            *.byt
	    *.flg

Routines called: none

END
  exit 1;
}

sub System {
  print "Running...\n";
  print join(' ', @_), "\n";
  system(@_);
}

@ARGV > 0 or Usage();

my $image = shift;
my $width = `use_rsc.pl $image read WIDTH` or die "Use dgx manually.\n";
 
if ($image =~ /\.slc/) {   
  System("mdx", $image, -c8, $width, @ARGV);
} 
elsif ($image =~ /\.int/) {   
  System("mdx", $image, -c8, $width, @ARGV);
} 
elsif ($image =~ /\.cor/) {
  System("mdx", "-s", $width, -rmg, $image, "-RMG-Mag", "-RMG-INF","-wrap","1.0","-addr","0.2", @ARGV); #1
}
elsif ($image =~ /\.scor/) { 
  System("mdx", $image, -r4, $width, @ARGV); #1
}
elsif ($image =~ /\.amp/) {   
  System("mdx", $image, -c8, $width, @ARGV);
}   
elsif ($image =~ /\.unw/) { 
  System("mdx", "-s", $width, "-rmg", $image, "-RMG-Mag", "-RMG-INF","-wrap","6.28", @ARGV);
}
elsif ($image =~ /\.hgt/) {   
  System("mdx", $image, -rmg, $width, @ARGV);
}
elsif ($image =~ /\.hgt_holes/) {   
  System("mdx", $image, -rmg, $width, @ARGV);
}
elsif ($image =~ /\.rect/) {   
  System("mdx", $image, -rmg, $width, @ARGV);
}
elsif ($image =~ /\.(dem|dte|dtm)/) {   
  System("mdx", $width, -i2, $image, "-dte", "-slope","-dte","-wrap", "100", @ARGV);
}
elsif ($image =~ /\.msk/) {
  System("mdx", $image, -rmg, $width, @ARGV);
}
elsif ($image =~ /\.byt/) {
  System("mdx", $image, -i1, $width, @ARGV);
}
elsif ($image =~ /\.flg/) {
  System("mdx", $image, -i1, $width, @ARGV);
}
else {print "$image has unrecognizable suffix\n"; Usage();}
exit 0;
=pod

=head1 HISTORY

=head1 LAST UPDATE

=cut
