#!/usr/bin/perl
###mdx.pl
##### Usage info/check and assignment of command line arguments

$] >= 5.004 or die "Perl version must be >= 5.004 (Currently $]).\n";

sub Usage {
  print STDERR <<END;

Usage: mdx.pl imagefile 

Function:  runs dgx based on imagefile.rsc

Recognizes: *.slc
            *.int *.flat
            *.cor
            *.unw
            *.amp
            *.hgt
            *.hgt_holes
            *.dem
            *.dte
            *.dtm
            *.rect
            *.msk
            *.byt
	    *.flg

Routines called: none

END
  exit 1;
}

sub System {
  print "Running...\n";
  print join(' ', @_), "\n";
  system(@_);
}

@ARGV > 0 or Usage();

my $image = shift;
my $width = `use_rsc.pl $image read WIDTH` or die "Use dgx manually.\n";
 
if ($image =~ /\.slc/) {   
  System("mdx", $image, -c8, -s, $width, @ARGV);
} 
elsif ($image =~ /\.int/) {
  System("mdx", $image, -c8, -s, $width, @ARGV);
}
elsif ($image =~ /\.flat/) {   
  System("mdx", $image, -c8, -s, $width, @ARGV);
} 
elsif ($image =~ /\.cor/) {
  System("mdx", $image, -rmg, -s, $width, @ARGV); #1
}
elsif ($image =~ /\.scor/) { 
  System("mdx", $image, -r4, -s, $width, @ARGV); #1
}
elsif ($image =~ /\.amp/) {   
  System("mdx", $image, -c8, -s, $width, @ARGV);
}   
elsif ($image =~ /\.unw/) {   # rewrap phase
  System("mdx", "-s", $width, $image, -rmg,  "-RMG-Mag -CW -RMG-Hgt -wrap", 6.28, @ARGV);
}
elsif ($image =~ /\.hgt/) {   
  System("mdx", $image, -rmg, -s, $width, @ARGV);
}
elsif ($image =~ /\.hgt_holes/) {   
  System("mdx", $image, -rmg, -s, $width, @ARGV);
}
elsif ($image =~ /\.rect/) {   
  System("mdx", $image, -rmg, -s, $width, @ARGV);
}
elsif ($image =~ /\.(dem|dte|dtm)/) {   
  System("mdx", $image, -slope, -i2, -s, $width, $image, -i2, -s, $width, -cmap, cmy, -wrap, 100, @ARGV);
}
elsif ($image =~ /\.msk/) {
  System("mdx", $image, -rmg, -s, $width, -cmap, cmy, @ARGV);
}
elsif ($image =~ /\.byt/) {
  System("mdx", $image, -i1, -s, $width, @ARGV);
}
elsif ($image =~ /\.flg/) {
  System("mdx", $image, -i1, -s, $width, @ARGV);
}
else {print "$image has unrecognizable suffix\n"; Usage();}
exit 0;
=pod

=head1 HISTORY

=head1 LAST UPDATE

=cut
