#!/usr/bin/perl
### use_rsc.pl

$] >= 5.004 or die "Perl version must be >= 5.004 (Currently $]).\n";

use Env qw(INT_SCR);
#use lib ".";  #### Location of Generic.pm
use Generic;

##### Usage info/check and assignment of command line arguments

sub Usage{

`$INT_SCR/pod2man.pl  $INT_SCR/use_rsc.pl`;
exit 1;
}
@ARGV > 1 or Usage();

$rscfile1 = shift;
$task     = shift;



### Check tasks
if ($task eq "merge"){
  $rscfile2 = shift(@ARGV);
}
elsif ($task =~ /^(read|delete|write)$/) {
  for ($i=0; $keywords[$i] = shift(@ARGV); $i++) {
    if ($task eq "write"){
      $value = shift (@ARGV);
      $value or $value = 0;
      $values[$i] = $value;
    }
  }
}
else {
  print STDERR "Woops, unknown task <$task>\n";
  Usage ();
}


##### check rscfile format #####
$rscfile1 =~ /\.rsc$/ or $rscfile1 = "$rscfile1.rsc";
$rscfile2 =~ /\.rsc$/ or $rscfile2 = "$rscfile2.rsc";


##### read keyword value #####

if ($task eq "read") {
  open RSC1, "$rscfile1" or die "Can't read $rscfile1\n";
  foreach $keyword (@keywords){ 
    $keyword or next;
    $found = 0;
    seek RSC1, 0, 0;
    foreach $line (<RSC1>) {
      if ($line =~ /^$keyword\s+(\S+)/) {
	print "$1 ";
	$found = 1;   #match only first occurence
	last;  
      }
    } 
    $found or print "0 ";
  }
  close(RSC1) or warn "$0: error in closing file $!\n";
} 

##### delete keyword and value #####

if ($task eq "delete") {
  foreach $keyword (@keywords){
    $keyword or next;
    open RSC1, "$rscfile1"  or die "Can't read $rscfile1\n";    
    open RSC2 , ">temp.rsc" or die "Can't write to temp.rsc\n"; 
    foreach $line (<RSC1>) {
      unless ($line=~/^$keyword(\s+)/) {
	print RSC2 "$line";   
      }
    }
    close(RSC1) or warn "$0: error in closing file $!\n";
    close(RSC2) or warn "$0: error in closing file $!\n";
    rename("temp.rsc",$rscfile1);
  }
} 

##### write/replace keyword value #####

if ($task eq "write") {
  foreach $keyword (@keywords){ 
    $keyword or next; 
    $value = shift(@values);
    $value or $value = 0;
    `touch $rscfile1`;
    open RSC1, "$rscfile1" or die "Can't read $rscfile1\n";   
    open RSC2, ">temp.rsc" or die "Can't write to temp.rsc\n"; 
    $found = 0;
    foreach $line (<RSC1>) {
      $caught = 0;
      $line =~ /^$keyword(\s+)(\S*)/ and $caught = 1; 
      if ($caught){
	printf RSC2 "%-40s %-30s\n",$keyword,$value;   
	$found = 1;
      }
      else{
	print RSC2 $line;
      }
    }
    unless ($found) {
      printf RSC2 "%-40s %-30s\n",$keyword,$value;   
    }
    close(RSC1) or warn "$0: error in closing file $!\n";
    close(RSC2) or warn "$0: error in closing file $!\n";
    rename("temp.rsc",$rscfile1);
  }
} 
##### merge rsc files, first file has precedence #####

if ($task eq "merge") {
  open RSC1, "$rscfile1" or die "Can't read $rscfile1\n"; 
  open RSC2, "$rscfile2" or die "Can't read $rscfile2\n";
  @rsc1 = <RSC1>;
  @rsc2 = <RSC2>;
  close(RSC1) or warn "$0: error in closing file $!\n";
  open RSC1, ">>$rscfile1" or die "Can't write to $rscfile1\n";
  $found = 0;

  foreach $line2 (@rsc2) {
    ($keyword2,$value) = split(" ",$line2,2);
    $found = 0;

    foreach $line (@rsc1) {
      ($keyword,$value) = split(" ",$line,2);
      if ($keyword eq $keyword2) { 
        $found = 1;
        last;
      }       
    } 
    unless ($found) {
      print RSC1 "$line2";   
    }
  }
  close(RSC1) or warn "$0: error in closing file $!\n";
  close(RSC2) or warn "$0: error in closing file $!\n";
}

exit 0;

=pod

=head1 USAGE

B<use_rsc.pl> I<rscfile read   keyword1 [keyword2] ...>

       use_rsc.pl rsc delete keyword1 [keyword2] ...
       use_rsc.pl rsc write  keyword1 value1 [keyword2 value2] ...
       use_rsc.pl rsc merge  rsc_prefix2

 Note: task=write will also replace an existing value.
       task=delete will remove the entire line.
       task=merge will form the union and dump into file1
       rscfile can be full name or just prefix

=head1 FUNCTION

Manipulates the InSAR *.rsc (resource files)

=head1 ROUTINES CALLED

none

=head1 CALLED BY

none

=head1 FILES USED

I<rscfile>

=head1 FILES CREATED

none

=head1 HISTORY

Shell Script : Francois ROGEZ 96/98

Perl  Script : Rowena LOHMAN 04/18/98

=head1 LAST UPDATE

Rowena Lohman, Jun 10, 1998

=cut
